package gov.va.med.mhv.integration.util;

import java.util.Date;

public class MHVDate {
	
	private String format;
	private boolean dateOnly;
	private Date date;
	
	public MHVDate(String format, boolean dateOnly, Date date) {
		this.dateOnly = dateOnly;
		this.format = format;
		this.date = date;
	}
	
	public MHVDate(MHVDateFormat df, Date date) {
		this.dateOnly = df.isDateOnly();
		this.format = df.getFormat();
		this.date = date;
	}

	public boolean isDateOnly() {
		return dateOnly;
	}

	public void setDateOnly(boolean dateOnly) {
		this.dateOnly = dateOnly;
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}
	
	public String toString() {
		return date.toString() + "; isDateOnly=" + isDateOnly();
	}
	
	/**
	 * Based on the format that was used during parsing we will format the output
	 * accordingly.  So a Date only value will return a date with no time.  Alternatively,
	 * a date with a time present will convert that into a date & time.
	 * 
	 * @return "22 Mar 2011 @ 1000" or "22 Mar 2011"
	 */
	public String toDateOrDateTime() {
		return (isDateOnly()?DateUtil.transformDateOnly(date):DateUtil.transformDateTime(date));
	}
}